<?php
/**
* @author Jan Pavelka, http://www.phoca.cz
* @package Xmap
* @license GNU/GPL
* @description Xmap plugin for Phoca Documentation component
*/

defined( '_VALID_MOS' ) or defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/** Adds support for Phoca Download Sections to Xmap */
class xmap_com_phocadocumentation {
 
	/*
	* This function is called before a menu item is printed. We use it to set the
	* proper uniqueid for the item
	*/
	function prepareMenuItem(&$node) {
           return true;
	}

	/** Get the content tree for this kind of content */
	function getTree( &$xmap, &$parent, &$params ) {

		if (defined('JPATH_SITE')) {
			$mosConfig_absolute_path = JPATH_SITE;
		} else {
			global $mosConfig_absolute_path;
		}

		
		$include_articles = xmap_com_phocadocumentation::getParam($params,'include_articles',1);
		$include_articles = ( $include_articles == 1
				  || ( $include_articles == 2 && $xmap->view == 'xml') 
				  || ( $include_articles == 3 && $xmap->view == 'html'));
		$params['include_articles'] = $include_articles;

		$priority = xmap_com_phocadocumentation::getParam($params,'cat_priority',$parent->priority);
		$changefreq = xmap_com_phocadocumentation::getParam($params,'cat_changefreq',$parent->changefreq);
		if ($priority  == '-1')
			$priority = $parent->priority;
		if ($changefreq  == '-1')
			$changefreq = $parent->changefreq;

		$params['cat_priority'] = $priority;
		$params['cat_changefreq'] = $changefreq;

		$priority = xmap_com_phocadocumentation::getParam($params,'down_priority',$parent->priority);
		$changefreq = xmap_com_phocadocumentation::getParam($params,'down_changefreq',$parent->changefreq);
		if ($priority  == '-1')
			$priority = $parent->priority;
		if ($changefreq  == '-1')
			$changefreq = $parent->changefreq;

		$params['down_priority'] = $priority;
		$params['down_changefreq'] = $changefreq;

		if ( ! file_exists($mosConfig_absolute_path . '/components/com_phocadocumentation/phocadocumentation.php') ) {
			return false;
		}
		
		// Traverse the Section/Category Hierarchy
		xmap_com_phocadocumentation::getSectionTree($xmap, $parent, $params);
		
		return true;
	}
	

	/** Phoca Download Sections */
	function getSectionTree( &$xmap, &$parent,&$params ) {
		if (defined('JPATH_SITE')) {
			$database = &JFactory::getDBO();
			$mosConfig_absolute_path = JPATH_SITE;
		} else {
			global $database,$mosConfig_absolute_path;
		}
		
		$displaySections = xmap_com_phocadocumentation::getParam($params,'display_sections','');
		$ds = '';
		if (count($displaySections) > 1) {
			JArrayHelper::toInteger($displaySections);
			$displaySectionsString	= implode(',', $displaySections);
			$ds	= ' AND id IN ( '.$displaySectionsString.' ) ';
		} else if ((int)$displaySections > 0) {
			$ds	= ' AND id IN ( '.$displaySections.' ) ';
		}
		
		$hideSections = xmap_com_phocadocumentation::getParam($params,'hide_sections','');
		$hs = '';
		if (count($hideSections) > 1) {
			JArrayHelper::toInteger($hideSections);
			$hideSectionsString	= implode(',', $hideSections);
			$hs	= ' AND id NOT IN ( '.$hideSectionsString.' ) ';
		} else if ((int)$hideSections > 0) {
			$hs	= ' AND id NOT IN ( '.$hideSections.' ) ';
		}
		
		$query = 	"SELECT id, alias, title, '0' as pid\n" .
		 		"FROM #__sections \n" .
		 		"WHERE PUBLISHED=1 \n" .
				$ds . " ".$hs;
		 		"ORDER BY title";
		$database->setQuery( $query );
		
		$rows = $database->loadObjectList();

		$xmap->changeLevel(1);
		foreach($rows as $row) {
			$node = new stdclass;

			$node->id = $parent->id;
			$node->uid = $parent->uid.'s'.$row->id;
			$node->browserNav = $parent->browserNav;
		    	$node->name = stripslashes($row->title);
			$node->modified = intval(strtotime('now'));
			$node->priority = $params['cat_priority'];
			$node->changefreq = $params['cat_changefreq'];
			
			if (isset($row->alias) && $row->alias != '') {
				$phSid = $row->id. ":".$row->alias;
			} else {
				$phSid = $row->id;
			}
			
			$node->link = str_replace('sections','section',$parent->link).'&amp;id='.$phSid;
			$node->pid = $row->pid;	// parent id
		    	if ($xmap->printNode($node) !== FALSE) {
				xmap_com_phocadocumentation::getCategoryTree( $xmap, $parent, $params, $row->id);
			}
	    	}
	    	$xmap->changeLevel(-1);
	}
		
	/** Phoca Download Categories */
	function getCategoryTree( &$xmap, &$parent,&$params, $sectionid=0, $p_id=0) {
		if (defined('JPATH_SITE')) {
			$database = &JFactory::getDBO();
			$mosConfig_absolute_path = JPATH_SITE;
		} else {
			global $database,$mosConfig_absolute_path;
		}
		
		$query  = 	"SELECT id, alias, title, parent_id as pid \n" .
				"FROM #__categories \n" .
				"WHERE parent_id=" . $p_id . "\n" .
				"AND section=" . $sectionid . "\n" .
				"AND published=1\n" .
				"ORDER BY title";		 		 
		 
		$database->setQuery( $query );
		$rows = $database->loadObjectList();	
				 
		$xmap->changeLevel(1);
		foreach($rows as $row) {
			$node = new stdclass;
			$node->id = $parent->id;
			$node->uid = $parent->uid.'c'.$row->id;
			$node->browserNav = $parent->browserNav;
		    	$node->name = stripslashes($row->title);
			$node->modified = intval(strtotime('now'));
			$node->priority = $params['cat_priority'];
			$node->changefreq = $params['cat_changefreq'];
			if (isset($row->alias) && $row->alias != '') {
				$phCid = $row->id. ":".$row->alias;
			} else {
				$phCid = $row->id;
			}
			$node->link = str_replace('sections','category',$parent->link).'&amp;id='.$phCid;
			
			$node->pid = $row->pid;									// parent id
		    	if ($xmap->printNode($node) !== FALSE) {		    		
				xmap_com_phocadocumentation::getCategoryTree( $xmap, $parent, $params, $sectionid, $row->id);
				if ( $params['include_articles'] ) {
					xmap_com_phocadocumentation::getArticles($xmap, $parent, $params, $sectionid, $row->id, $phCid);
				}
			}
	    	}
		$xmap->changeLevel(-1);   
        }


	/** Downloads */
	function getArticles( &$xmap, &$parent, &$params, $sectionid=0, $catid=0, $phCid ) {

		if (defined('JPATH_SITE')) {
			$database = &JFactory::getDBO();
			$mosConfig_absolute_path = JPATH_SITE;
		} else {
			global $database,$mosConfig_absolute_path;
		}
		$list = array();
		
		
		$jnow		=& JFactory::getDate();
		$now		= $jnow->toMySQL();
		$nullDate	= $database->getNullDate();
		
		$pub = 'AND ( '
		//.= ' ( a.created_by = ' . (int) $user->id . ' ) ';
		//.= '   OR ';
		.' ( state = 1'
		.' AND ( publish_up = '.$database->Quote($nullDate).' OR publish_up <= '.$database->Quote($now).' )'
		.' AND ( publish_down = '.$database->Quote($nullDate).' OR publish_down >= '.$database->Quote($now).' )'
		.'   ) '
		.'   OR '
		.' ( state = -1 ) '
		.' ) ';

		$query  = 	"SELECT id, alias, title, modified as mdate, '' as pid"
				."\n FROM #__content  "
				//."\n WHERE state = 1 "
				//."\n AND sectionid = $sectionid "
				."\n WHERE catid = $catid "
				."\n ".$pub
				."\n ORDER BY title";

		$database->setQuery( $query );
		$rows = $database->loadObjectList();
		
		$itemid = xmap_com_phocadocumentation::getParam($params,'itemid','');
		if((int)$itemid > 0) {
			$itemidOutput = '&amp;Itemid='.(int)$itemid;
		} else {
			$itemidOutput = '';
		}

		$xmap->changeLevel(1);		
		foreach($rows as $row) {
			$node = new stdclass;

			$node->id = $parent->id;
			$node->uid = $parent->uid.'d'.$row->id;
			$node->browserNav = $parent->browserNav;
		    	$node->name = stripslashes($row->title);
			$node->modified = intval(strtotime($row->mdate));
			$node->priority = $params['down_priority'];
			$node->changefreq = $params['down_changefreq'];
			if (isset($row->alias) && $row->alias != '') {
				$phFid = $row->id. ":".$row->alias;
			} else {
				$phFid = $row->id;
			}
			
			$node->link = 'index.php?option=com_content&view=article&catid='.$phCid.'&id='.$phFid.$itemidOutput;
			//$node->link = str_replace('sections','category',$parent->link).'&amp;id='.$phCid . $itemidOutput;
			
			$node->pid = $row->pid;	 // parent id
			$xmap->printNode($node);
	    	}
		$xmap->changeLevel(-1);		
		return true;
	}

	function &getParam($arr, $name, $def) {
		if ( defined('JPATH_SITE') ) {
			$var = JArrayHelper::getValue( $arr, $name, $def, '' );
		} else {
			$var = xmap_com_phocadocumentation::getParam( $arr, $name, $def);
		}
		return $var;
	}
}