<?php
/*
 * @package Joomla 1.5
 * @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 *
 * @plugin Phoca Plugin
 * @copyright Copyright (C) Jan Pavelka www.phoca.cz
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.plugin.plugin' );

class plgContentPhocaDownload extends JPlugin
{	
	function plgContentPhocaDownload( &$subject, $params ) {
        parent::__construct( $subject, $params  );
    }

	function onPrepareContent( &$article, &$params, $limitstart ) {
		

		$document		= &JFactory::getDocument();
		$db 			= &JFactory::getDBO();		
		$plugin 		= &JPluginHelper::getPlugin('content', 'phocadownload');
	 	$pluginP 		= new JParameter( $plugin->params );
		$iSize			= $pluginP->get('icon_size', 32);
		
		// Start Plugin
		$regex_one		= '/({phocadownload\s*)(.*?)(})/si';
		$regex_all		= '/{phocadownload\s*.*?}/si';
		$matches 		= array();
		$count_matches	= preg_match_all($regex_all,$article->text,$matches,PREG_OFFSET_CAPTURE | PREG_PATTERN_ORDER);

		$document->addStyleSheet(JURI::base(true).'/plugins/content/phocadownload/css/phocadownload.css');
		
		// Start if count_matches
		if ($count_matches != 0) {
			
			// Start CSS
			for($i = 0; $i < $count_matches; $i++) {
				
				$view	= '';
				$id		= '';
				$text	= '';
				$target = '';
				
				// Get plugin parameters
				$phocadownload	= $matches[0][$i][0];
				preg_match($regex_one,$phocadownload,$phocadownload_parts);
				$parts			= explode("|", $phocadownload_parts[2]);
				$values_replace = array ("/^'/", "/'$/", "/^&#39;/", "/&#39;$/", "/<br \/>/");

				
				foreach($parts as $key => $value) {
					$values = explode("=", $value, 2);
					
					foreach ($values_replace as $key2 => $values2) {
						$values = preg_replace($values2, '', $values);
					}
					
					// Get plugin parameters from article
						 if($values[0]=='view')				{$view				= $values[1];}
					else if($values[0]=='id')				{$id				= $values[1];}
					else if($values[0]=='text')				{$text				= $values[1];}
					else if($values[0]=='target')			{$target			= $values[1];}
					
				}
				
				switch($target) {
					case 'b':
						$targetOutput = 'target="_blank" ';
					break;
					case 't':
						$targetOutput = 'target="_top" ';
					break;
					case 'p':
						$targetOutput = 'target="_parent" ';
					break;
					case 's':
						$targetOutput = 'target="_self" ';
					break;
					default:
						$targetOutput = '';
					break;
				}
				
				$output = '';
				//Itemid
				$menu 		=& JSite::getMenu();
				$itemSection= $menu->getItems('link', 'index.php?option=com_phocadownload&view=sections');
				if(isset($itemSection[0])) {
					$itemId = $itemSection[0]->id;
				} else {
					$itemId = JRequest::getVar('Itemid', 1, 'get', 'int');
				}
				
				switch($view) {
					
					// - - - - - - - - - - - - - - - -
					// SECTIONS
					// - - - - - - - - - - - - - - - -
					case 'sections':						
						if ($text !='') {
							$textOutput = $text;
						} else {
							$textOutput = JText::_('Download Sections');
						}
						$output .= '<div class="phocadownloadsections'.(int)$iSize.'"><a href="'. JRoute::_('index.php?option=com_phocadownload&view=sections&Itemid='. $itemId).'" '.$targetOutput.'>'. $textOutput.'</a></div>';
					break;
					
					// - - - - - - - - - - - - - - - -
					// SECTION
					// - - - - - - - - - - - - - - - -
					case 'section':
						if ((int)$id > 0) {
							$query = 'SELECT a.id, a.title, a.alias,'
							. ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(\':\', a.id, a.alias) ELSE a.id END as slug'
							. ' FROM #__phocadownload_sections AS a'
							. ' WHERE a.id = '.(int)$id;
							
							$db->setQuery($query);
							$item = $db->loadObject();
							
							if (isset($item->id) && isset($item->slug)) {
								
								if ($text !='') {
									$textOutput = $text;
								} else if (isset($item->title) && $item->title != '') {
									$textOutput = $item->title;
								} else {
									$textOutput = JText::_('Download Section');
								}
							
								$output .= '<div class="phocadownloadsection'.(int)$iSize.'"><a href="'. JRoute::_('index.php?option=com_phocadownload&view=section&id='.$item->slug.'&Itemid='. $itemId).'" '.$targetOutput.'>'. $textOutput.'</a></div>';
							}
						}
					break;
					
					// - - - - - - - - - - - - - - - -
					// CATEGORY
					// - - - - - - - - - - - - - - - -
					case 'category':
						if ((int)$id > 0) {
							$query = 'SELECT a.id, a.title, a.alias,'
							. ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(\':\', a.id, a.alias) ELSE a.id END as slug'
							. ' FROM #__phocadownload_categories AS a'
							. ' WHERE a.id = '.(int)$id;
							
							$db->setQuery($query);
							$item = $db->loadObject();
							
							if (isset($item->id) && isset($item->slug)) {
								
								if ($text !='') {
									$textOutput = $text;
								} else if (isset($item->title) && $item->title != '') {
									$textOutput = $item->title;
								} else {
									$textOutput = JText::_('Download Category');
								}
							
								$output .= '<div class="phocadownloadcategory'.(int)$iSize.'"><a href="'. JRoute::_('index.php?option=com_phocadownload&view=category&id='.$item->slug.'&Itemid='. $itemId).'" '.$targetOutput.'>'. $textOutput.'</a></div>';
							}
				
						}
					break;
					
					// - - - - - - - - - - - - - - - -
					// FILE
					// - - - - - - - - - - - - - - - -
					case 'file':
						if ((int)$id > 0) {
							$query = 'SELECT a.id, a.title, a.alias, c.id as catid, a.confirm_license, c.title as cattitle, c.alias as catalias,'
							. ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(\':\', a.id, a.alias) ELSE a.id END as slug,'
							. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(\':\', c.id, c.alias) ELSE c.id END as catslug'
							. ' FROM #__phocadownload AS a'
							. ' LEFT JOIN #__phocadownload_categories AS c ON a.catid = c.id'
							. ' WHERE a.id = '.(int)$id;
							
							$db->setQuery($query);
							$item = $db->loadObject();
							
							if (isset($item->id) && isset($item->slug) && isset($item->catid) && isset($item->catslug)) {
								
								if ($text !='') {
									$textOutput = $text;
								} else if (isset($item->title) && $item->title != '') {
									$textOutput = $item->title;
								} else {
									$textOutput = JText::_('Download File');
								}
							
								if (isset($item->confirm_license) && $item->confirm_license > 0) {
									$output .= '<div class="phocadownloadfile'.(int)$iSize.'"><a href="'. JRoute::_('index.php?option=com_phocadownload&view=file&id='.$item->slug.'&Itemid='.$itemId).'" '.$targetOutput.'>'. $textOutput.'</a></div>';	
								} else {
									$output .= '<div class="phocadownloadfile'.(int)$iSize.'"><a href="'. JRoute::_('index.php?option=com_phocadownload&view=category&id='.$item->catslug.'&download='.$item->slug.'&Itemid='. $itemId).'" '.$targetOutput.'>'. $textOutput.'</a></div>';
								}
							}
				
						}
					break;
				}
				$article->text = preg_replace($regex_all, $output, $article->text, 1);
			}
		}// end if count_matches
		return true;
	}
}
?>