<?php
/*
 * @package Joomla 1.5
 * @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 *
 * @module Phoca - Phoca Module
 * @copyright Copyright (C) Jan Pavelka www.phoca.cz
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @based on javascript: dTree 2.05 www.destroydrop.com/javascript/tree/
 * @copyright (c) 2002-2003 Geir Landr
 */
defined('_JEXEC') or die('Restricted access');// no direct access
if (!JComponentHelper::isEnabled('com_phocadownload', true)) {
	return JError::raiseError(JText::_('Phoca Download Error'), JText::_('Phoca Download is not installed on your system'));
}
$user 		= &JFactory::getUser();
$db 		= &JFactory::getDBO();
$menu 		= &JSite::getMenu();
$document	= &JFactory::getDocument();
		
// Start CSS
$document->addStyleSheet(JURI::base(true).'/modules/mod_phocadownload_tree/assets/dtree.css');
$document->addScript( JURI::base(true) . '/modules/mod_phocadownload_tree/assets/dtree.js' );
$imgPath = JURI::base(true) . '/modules/mod_phocadownload_tree/assets/';

//Unique id for more modules
$treeId = "d".uniqid( "tree_" );

// Current category info
$id 	= JRequest::getVar( 'id', 0, '', 'int' );
$option = JRequest::getVar( 'option', 0, '', 'string' );
$view 	= JRequest::getVar( 'view', 0, '', 'string' );


// Params
$hide_categories = $params->get( 'hide_categories', '');
$hide_sections = $params->get( 'hide_sections', '' );

$hideSecArray	= explode( ';', trim($hide_sections) );
$hideSecSql		= '';
if (is_array($hideSecArray)) {
	foreach ($hideSecArray as $value) {
		$hideSecSql .= ' AND s.id != '. (int) trim($value) .' ';
	}
}

$hideCatArray	= explode( ';', trim($hide_categories) );
$hideCatSql		= '';
if (is_array($hideCatArray)) {
	foreach ($hideCatArray as $value) {
		$hideCatSql .= ' AND cc.id != '. (int) trim($value) .' ';
	}
}
// Add Access check - codejunkie 2009-10-07
$aid       = $user->get('aid', 0);

// All Sections - - - - - - -
$query = 'SELECT s.title AS text, s.id AS id, s.alias as alias, s.access as access,'
		. ' CASE WHEN CHAR_LENGTH(s.alias) THEN CONCAT_WS(\':\', s.id, s.alias) ELSE s.id END as secslug '
		. ' FROM #__phocadownload_sections AS s'
		. ' WHERE s.published = 1'
		. $hideSecSql
		// Add Access check - codejunkie 2009-10-07
		. ' AND s.access <= ' . $aid
		. ' ORDER BY s.ordering';
$db->setQuery( $query );
$sections = $db->loadObjectList();

// All Categories - - - - -
$query = 'SELECT cc.title AS text, cc.id AS id, cc.parent_id as parentid, cc.section as section, cc.alias as alias, cc.access as access,'
		. ' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(\':\', cc.id, cc.alias) ELSE cc.id END as catslug '
		. ' FROM #__phocadownload_categories AS cc'
		. ' WHERE cc.published = 1'
		. $hideCatSql
		// Add Access check - codejunkie 2009-10-07
		. ' AND cc.access <= ' . $aid
		. ' ORDER BY cc.ordering';
$db->setQuery( $query );
$categories = $db->loadObjectList();


// Link
// Set Itemid id, exists this link in Menu?
$menu 			= &JSite::getMenu();
$itemsSec	= $menu->getItems('link', 'index.php?option=com_phocadownload&view=sections');
if(isset($itemsSec[0])) {
	$itemId = $itemsSec[0]->id;
	$alias 	= '';
} else {
	$itemId = 0;
	$alias	= '';
}

// Tree
$i = 1;
$tree 		= array();
$newIdSec	= array();
$newIdCat	= array();
foreach ($sections as $keySec => $valueSec) {
	$link = JRoute::_('index.php?option=com_phocadownload&view=section&id='. $valueSec->secslug .'&Itemid='.$itemId);	
	$tree[] =  $treeId.'.add('.$i.',0,\''.addslashes($valueSec->text).'\',\''.$link.'\');'."\n";
	$newIdSec[$valueSec->id] = $i;
	$j = $i;$i++;
	foreach ($categories as $keyCat => $valueCat) {
		if ((int)$valueCat->section == (int)$valueSec->id) {
			$link = JRoute::_('index.php?option=com_phocadownload&view=category&id='. $valueCat->catslug .'&Itemid='.$itemId);
			$tree[] =  $treeId.'.add('.$i.','.$j.',\''.addslashes($valueCat->text).'\',\''.$link.'\');'."\n";
			$newIdCat[$valueCat->id] = $i;
			$i++;
		}
	}
}

// We added unique numbers to categories and sections (because section can have the same id as category we must to add other ids)
if ( $option == 'com_phocadownload' && $view == 'section' ) {
	if (isset($newIdSec[$id])) {
		$catAndSecId = (int)$newIdSec[$id];
	} else {
		$catAndSecId = 0;
	}
} else if ( $option == 'com_phocadownload' && $view == 'category' ) {
	if (isset($newIdCat[$id])) {
		$catAndSecId = (int)$newIdCat[$id];
	} else {
		$catAndSecId = 0;
	} 
} else {
	$catAndSecId = 0;
}

// Categories (Head)
$linkSections = JRoute::_('index.php?option=com_phocadownload&view=sections&Itemid='.$itemId);
// Create javascript code	
$jsTree = '';
foreach($tree as $key => $value) {
	$jsTree .= $value ;
}
//  Output
$output ='<div style="text-align:left;">';
$output.='<div class="dtree">';
$output.='<script type="text/javascript">'."\n";
$output.='<!--'."\n";
$output.=''."\n";
$output.=''.$treeId.' = new dTree2568(\''.$treeId.'\', \''.$imgPath.'\');'."\n";
$output.=''."\n";
$output.=''.$treeId.'.add(0,-1,\''.JText::_( 'Download' ).'\',\''.$linkSections.'\');'."\n";
$output.=$jsTree;
$output.=''."\n";
$output.='document.write('.$treeId.');'."\n";
$output.=''.$treeId.'.openTo('. (int) $catAndSecId.',\'true\');'. "\n";
$output.=''."\n";
$output.='//-->'."\n";
$output.='</script>';
$output.='</div></div>';

require(JModuleHelper::getLayoutPath('mod_phocadownload_tree'));
?>